<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services\handlerCreator;

use apexl\Io\includes\System;
use apexl\Io\modules\logger\dto\handlerConfigParams\fileHandlerConfigParams;
use Monolog\Handler\RotatingFileHandler;

class fileLogHandlerCreator extends handlerCreator
{
    public function create(): RotatingFileHandler
    {
        /** @var fileHandlerConfigParams $params */
        $params = $this->handlerConfig->params;
        $file = $params->file ?? sprintf('%s.log', $this->streamName);
        if (!str_starts_with($file, '/')) {
            $file = sprintf('%s/../%s/%s', System::getBasePath(), $this->streamConfig->logDirectory, $file);
        }

        return new RotatingFileHandler($file, $params->maxFiles ?? 7, $this->level());
    }
}
