<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\whoops\handlers;

use apexl\Io\modules\logger\traits\getsSimpleTrace;
use Whoops\Handler\Handler;

class ioLoggerHandler extends Handler
{
    use getsSimpleTrace;

    public function handle(): ?int
    {
        $exception = $this->getException();

        logger('error')->error(
            $exception->getMessage(),
            ['trace' => $this->simpleTrace($exception->getTrace())]
        );

        return Handler::DONE;
    }
}
