<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\hooks;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\logger\traits\getsSimpleTrace;
use Throwable;

final readonly class errorListener implements AbstractHook
{
    use getsSimpleTrace;

    public function hooks(): array
    {
        return ['error'];
    }

    public function __invoke(Throwable $thrown): void
    {
        logger('error')->error(sprintf('%s: %s', $thrown::class, $thrown->getMessage()), [
            'trace' => self::simpleTrace($thrown->getTrace()),
        ]);
    }
}
