<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services\handlerCreator;

use apexl\Io\modules\logger\enums\Handler;
use apexl\Io\modules\logger\interfaces\handlerCreatorInterface;
use UnexpectedValueException;
use UnhandledMatchError;

final readonly class handlerCreatorFactory
{
    public function __construct(
        private errorLogHandlerCreator $errorLogHandlerCreator,
        private fileLogHandlerCreator $fileLogHandlerCreator,
        private logstashLogHandlerCreator $logstashLogHandlerCreator,
        private databaseLogHandlerCreator $databaseLogHandlerCreator,
    ) {}

    public function make(
        Handler $destination,
    ): handlerCreatorInterface {
        try {
            return match ($destination) {
                Handler::ERROR_LOG => $this->errorLogHandlerCreator,
                Handler::FILE => $this->fileLogHandlerCreator,
                Handler::LOGSTASH => $this->logstashLogHandlerCreator,
                Handler::DATABASE => $this->databaseLogHandlerCreator,
            };
        } catch (UnhandledMatchError) {
            throw new UnexpectedValueException(
                sprintf('Handler %s not found', $destination->value)
            );
        }
    }
}