<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services;

use apexl\Io\modules\logger\dto\streamConfig;
use apexl\Io\modules\logger\services\handlerCreator\handlerCreatorFactory;

final readonly class loggerFactory
{
    public function __construct(private handlerCreatorFactory $handlerCreatorFactory) {}

    public function make(
        string $stream,
        streamConfig $config,
    ): logger {
        return new logger($stream, $config, $this->handlerCreatorFactory);
    }
}