<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services;

use apexl\Io\modules\logger\dto\LoggerConfig;
use apexl\Io\modules\logger\dto\streamConfig;
use apexl\Io\modules\logger\interfaces\loggerInterface;
use Exception;

final class loggerStore
{
    final public const string DEFAULT__LOGGER_STREAM = 'default';
    final public const string DEFAULT__ERROR_STREAM = 'error';
    /** @var loggerInterface[] */
    private array $streams = [];

    public function __construct(private readonly loggerFactory $loggerFactory, private readonly LoggerConfig $config) {}

    /**
     * @throws Exception
     */
    public function logger(string $stream = self::DEFAULT__LOGGER_STREAM): loggerInterface
    {
        if ($this->getStreamConfig($stream) === null) {
            error_log(sprintf('Unknown logger stream: %s', $stream), E_USER_WARNING);

            $stream = self::DEFAULT__LOGGER_STREAM;
        }

        if (!isset($this->streams[$stream])) {
            $this->streams[$stream] = $this->initStream($stream);
        }

        return $this->streams[$stream];
    }

    private function getStreamConfig(string $stream): ?streamConfig
    {
        return $this->config->streams[$stream] ?? null;
    }

    /**
     * @throws Exception
     */
    private function initStream(string $stream): loggerInterface
    {
        return $this->loggerFactory->make($stream, $this->getStreamConfig($stream));
    }
}
