<?php declare(strict_types=1);

use apexl\Io\modules\logger\interfaces\loggerInterface;
use apexl\Io\modules\logger\services\errorLogLogger;
use apexl\Io\modules\logger\services\loggerStore;
use function apexl\Io\container;

if (!function_exists('logger')) {
    function logger(string $stream = loggerStore::DEFAULT__LOGGER_STREAM): loggerInterface
    {
        try {
            return container()->get(loggerStore::class)->logger($stream);
        } catch (Throwable $e) {
            error_log(
                sprintf(
                    'Error fetching logger; falling back to error_log(): %s',
                    $e->getMessage()
                )
            );

            return new errorLogLogger();
        }
    }
}
