<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services;

use apexl\Io\modules\logger\interfaces\loggerInterface;
use Psr\Log\AbstractLogger;
use Psr\Log\LogLevel;

class errorLogLogger extends AbstractLogger implements loggerInterface
{

    public function log($level, $message, array $context = []): void
    {
        $level = match ($level) {
            LogLevel::EMERGENCY,
            LogLevel::ERROR,
            LogLevel::CRITICAL,
            LogLevel::ALERT => E_USER_ERROR,

            LogLevel::WARNING => E_USER_WARNING,

            LogLevel::NOTICE,
            LogLevel::DEBUG,
            LogLevel::INFO => E_USER_NOTICE,
        };

        error_log($message, $level);
    }
}
