<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services\handlerCreator;

use apexl\Io\modules\logger\dto\handlerConfig;
use apexl\Io\modules\logger\dto\streamConfig;
use Monolog\Handler\ErrorLogHandler;
use Monolog\Handler\HandlerInterface;

final readonly class errorLogHandlerCreator extends handlerCreator
{
    public function create(
        string $streamName,
        handlerConfig $handlerConfig,
        streamConfig $streamConfig
    ): HandlerInterface {
        {
            return new ErrorLogHandler(
                ErrorLogHandler::OPERATING_SYSTEM,
                $this->level($handlerConfig, $streamConfig),
            );
        }
    }
}
