<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger;

use apexl\Io\includes\Module;
use apexl\Io\modules\logger\dto\LoggerConfig;
use apexl\Io\modules\logger\hooks\errorListener;
use apexl\Io\modules\logger\hooks\whoopsHandlerListener;
use apexl\Io\services\InstallChecker;
use app\vendor\apexl\io\src\Io\interfaces\ProvidesHooksInterface;

class loggerModule extends Module implements ProvidesHooksInterface
{
    public function __construct(
        InstallChecker $installChecker,
        private readonly LoggerConfig $loggerConfig
    ) {
        parent::__construct($installChecker);
    }

    public function hooks(): array
    {
        if ($this->loggerConfig->catchErrors) {
            return [
                whoopsHandlerListener::class,
                errorListener::class,
            ];
        }

        return [];
    }
}
