<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services\handlerCreator;

use apexl\Io\modules\logger\dto\handlerConfig;
use apexl\Io\modules\logger\dto\streamConfig;
use apexl\Vault\Vault;
use Monolog\Handler\HandlerInterface;
use MySQLHandler\MySQLHandler;

final readonly class databaseLogHandlerCreator extends handlerCreator
{
    public function __construct(private Vault $db) {}

    public function create(
        string $streamName,
        handlerConfig $handlerConfig,
        streamConfig $streamConfig
    ): HandlerInterface {
        $connection = $this->db->getConnection();

        return new MySQLHandler(
            $connection,
            $handlerConfig->params->table,
            [],
            $this->level($handlerConfig, $streamConfig),
        );
    }
}
