<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\traits;

trait getsSimpleTrace
{
    protected static function simpleTrace(array $trace, int $limit = 5): array
    {
        return array_map(
            fn (array $line) => sprintf(
                '%s:%d - %s%s%s',
                $line['file'] ?? '-',
                $line['line'] ?? '-',
                $line['class'] ?? '-',
                $line['type'] ?? '-',
                $line['function'] ?? '-',
            ),
            array_slice($trace, 0, $limit),
        );
    }
}
