<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\dto;

use apexl\Utils\Strings\Camel;
use Spatie\DataTransferObject\DataTransferObject;
use stdClass;

abstract class handlerConfigParams extends DataTransferObject
{
    public static function factory(string $destination, array $params): \stdClass|\apexl\Io\modules\logger\dto\handlerConfigParams
    {
        $class = self::getHandlerConfigParamsClass($destination);

        return new $class($params);
    }

    private static function getHandlerConfigParamsClass(string $destination): string
    {
        $candidate = sprintf(
            '%s\\%sHandlerConfigParams',
            handlerConfigParams::class,
            Camel::camelCase($destination)
        );

        return class_exists($candidate) ? $candidate : stdClass::class;
    }
}
