<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\dto;

use apexl\Config\Singleton as Config;
use apexl\Io\modules\logger\enums\LogLevel;
use Exception;
use Spatie\DataTransferObject\DataTransferObject;
use stdClass;

class loggerConfig extends DataTransferObject
{
    public LogLevel $level;
    public bool $catchErrors = true;
    public streamConfigCollection $streams;

    /**
     * @throws Exception
     */
    public static function fromConfig(): loggerConfig
    {
        $config = config('logger');

        return new loggerConfig([
            'level' => isset($config['level']) ? LogLevel::from(
                $config['level']
            ) : LogLevel::WARNING,
            'catchErrors' => $config['catchErrors'] ?? true,
            'streams' => new streamConfigCollection(
                array_map(
                    fn(array $streamConfig) => streamConfig::fromConfig($streamConfig, $config),
                    (array) $config['streams'],
                )
            ),
        ]);
    }
}
