<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger;

use apexl\Io\includes\Module;
use apexl\Io\modules\logger\dto\loggerConfig;
use apexl\Io\modules\logger\hooks\errorListener;
use apexl\Io\modules\logger\hooks\whoopsHandlerListener;
use app\vendor\apexl\io\src\Io\interfaces\HasHooksInterface;
use Exception;

class loggerModule extends Module implements HasHooksInterface
{
    private loggerConfig $loggerConfig;

    public function __construct()
    {
        parent::__construct();

        try {
            $this->loggerConfig = loggerConfig::fromConfig();
        } catch (Exception $e) {
            user_error($e->getMessage(), E_USER_ERROR);
        }
    }

    public function hooks(): array
    {
        if ($this->loggerConfig->catchErrors) {

            return [
                whoopsHandlerListener::class,
                errorListener::class,
            ];
        }

        return [];
    }
}
