<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services\handlerCreator;

use apexl\Io\modules\logger\dto\handlerConfig;
use apexl\Io\modules\logger\dto\streamConfig;
use apexl\Io\modules\logger\enums\Handler;
use apexl\Io\modules\logger\interfaces\handlerCreatorInterface;
use UnexpectedValueException;

abstract class handlerCreator implements handlerCreatorInterface
{
    public static function factory(
        Handler $destination,
        string $streamName,
        handlerConfig $handlerConfig,
        streamConfig $streamConfig,
    ): handlerCreatorInterface {
        $class = match ($destination) {
            Handler::ERROR_LOG => errorLogHandlerCreator::class,
            Handler::FILE => fileLogHandlerCreator::class,
            Handler::LOGSTASH => logstashLogHandlerCreator::class,
            Handler::DATABASE => databaseLogHandlerCreator::class,
            default => throw new UnexpectedValueException(
                sprintf('Handler %s not found', $destination->value)
            ),
        };

        return new $class(
            streamName:  $streamName,
            handlerConfig: $handlerConfig,
            streamConfig: $streamConfig,
        );
    }

    public function __construct(
        protected $streamName,
        protected $handlerConfig,
        protected $streamConfig,
    ) {}

    public function level(): string
    {
        return ($this->handlerConfig?->level ?? $this->streamConfig->level)->value;
    }
}