<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services\handlerCreator;

use apexl\Io\modules\logger\dto\handlerConfigParams\logstashHandlerConfigParams;
use Monolog\Formatter\LogstashFormatter;
use Monolog\Handler\HandlerInterface;
use Monolog\Handler\SocketHandler;

class logstashLogHandlerCreator extends handlerCreator
{
    public function create(): HandlerInterface
    {
        /** @var logstashHandlerConfigParams $params */
        $params = $this->handlerConfig->params;
        $connectionString = sprintf(
            '%s:%s',
            $params->host,
            $params->port
        );

        $handler = new SocketHandler($connectionString, $this->level());

        $handler->setFormatter(
            new LogstashFormatter(
                $params->application ?? config('app.site.name'),
                $params->system,
            )
        );

        return $handler;
    }
}
