<?php

namespace apexl\Io\modules\menu;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\menu\callbacks\initialiseModules;
use apexl\Io\modules\menu\entities\menuEntity;
use apexl\Io\modules\menu\entities\menuLinkEntity;
use apexl\Io\modules\menu\services\Menu;

class menuModule extends Module
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Register Hook Callbacks.
     */
    public function registerCallbacks()
    {
        Hook::registerCallback('initialiseModule', initialiseModules::class.':registerMenuItems');
        //Hook::registerCallback('routePreBuild', routeCallbacks::class.':routePreBuild');
    }

    /**
     * Provide the install modules Schema.
     * @return mixed|void
     */
    public function schema()
    {
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    /**
     * Install method, add default menu items and menu nav items
     * @return bool|void
     * @throws \Exception
     */
    public function install()
    {
        //create main menu
        $mainMenu = new menuEntity();
        $mainMenu->name = "Main Menu";
        $mainMenu->module = "menu";
        $mainMenu->links = [
            (new menuLinkEntity())->setData([
                "title" => "Home",
                "routeName" => 'home',
                "href" => Routes::getRoutePattern('home'),
                "icon" => "home"
            ])
        ];
        $mainMenu->store();

        //create default account menu
        $accountMenu = new menuEntity();
        $accountMenu->name = "Account Menu";
        $accountMenu->module = "menu";
        $accountMenu->links = [
            (new menuLinkEntity())->setData([
                "title" => "Settings",
                "routeName" => 'user.display.settings',
                "href" => Routes::getRoutePattern('user.display.settings'),
                "icon" => "cogs"
            ]),
            (new menuLinkEntity())->setData([
                "title" => "Logout",
                "routeName" => 'user.logout',
                "href" => Routes::getRoutePattern('user.display.logout'),
                "icon" => "sign-out"
            ]),
        ];
        $accountMenu->store();
    }

    public function addServices()
    {
        return [
            Menu::class => function () {
                return Menu::getInstance();
            }
        ];
    }
}
