<?php

namespace apexl\Io\modules\menu\entities\operators;

class menuLinksOperator extends menuOperator
{
    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function load($id, $skipAccessCheck = false): array
    {
        $link = (object) $this->vault->select($this->dbTable)->fields()->where('id', $id)->execute()->fetchAssoc();
        if (!empty($link)) {
            $link->links = $this->getChildLinks($link->id);
        }

        return ['updateEntityData' => true, 'data' => $link];
    }

    public function getChildLinks($parentId)
    {
        $links = $this->vault->select($this->dbTable)->fields()->where('parentId', $parentId)->execute()->fetchAll();
        $linkEntities = [];
        foreach ($links as $link) {
            $children = $this->getChildLinks($link->id);
            if ($children) {
                $link->links = $children;
            }
            $linkEntities[$link->id] = $link;
        }

        return $linkEntities;
    }

    public function getMenuLinks($menuId)
    {
        $links = $this->vault->select($this->dbTable)->fields()->where('mid', $menuId)->execute()->fetchAll();
        $linkEntities = [];
        foreach ($links as $link) {
            $children = $this->getChildLinks($link->id);
            if ($children) {
                $link->links = $children;
            }
            $linkEntities[$link->id] = $link;
        }

        return $linkEntities;
    }
}
