<?php

namespace apexl\Io\modules\menu;

use apexl\Io\includes\Module;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\menu\entities\menuEntity;
use apexl\Io\modules\menu\entities\menuLinkEntity;
use apexl\Io\modules\menu\hooks\registerMenuItems;
use apexl\Io\modules\menu\services\Menu;
use app\vendor\apexl\io\src\Io\interfaces\HasHooksInterface;
use Exception;

class menuModule extends Module implements HasServicesInterface, HasHooksInterface
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Provide the modules Schema.
     */
    public function schema(): object
    {
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }

    /**
     * Install method, add default menu items and menu nav items
     * @throws Exception
     */
    public function install(): bool
    {
        //create main menu
        $mainMenu = new menuEntity();
        $mainMenu->name = "Main Menu";
        $mainMenu->module = "menu";
        $mainMenu->links = [
            (new menuLinkEntity())->setData([
                "title" => "Home",
                "routeName" => 'home',
                "href" => Routes::getRoutePattern('home'),
                "icon" => "home",
            ]),
        ];
        $mainMenu->store();

        //create default account menu
        $accountMenu = new menuEntity();
        $accountMenu->name = "Account Menu";
        $accountMenu->module = "menu";
        $accountMenu->links = [
            (new menuLinkEntity())->setData([
                "title" => "Settings",
                "routeName" => 'user.display.settings',
                "href" => Routes::getRoutePattern('user.display.settings'),
                "icon" => "cogs",
            ]),
            (new menuLinkEntity())->setData([
                "title" => "Logout",
                "routeName" => 'user.logout',
                "href" => Routes::getRoutePattern('user.display.logout'),
                "icon" => "sign-out",
            ]),
        ];
        $accountMenu->store();

        return true;
    }

    public function addServices(): array
    {
        return [
            Menu::class => fn() => Menu::getInstance(),
        ];
    }

    public function hooks(): array
    {
        return [
            registerMenuItems::class,
        ];
    }
}
