<?php

namespace apexl\Io\modules\menu\callbacks;

class routeCallbacks
{
    public function routePreBuild($routes)
    {
        //sort by weight
        $toBuild = [];
        //alter roots hook

        /* @var @todo Check if we can do this better */
        foreach ($routes as $name => $route) {
            //increment routes until we have an available slot for the given weight.
            $weight = $route->weight;
            if (isset($toBuild[$weight])) {
                do {
                    ++$weight; //we'll loop here until we have a slot, then move on. Otherwise we just skip
                } while (isset($toBuild[$weight]));
            }
            $toBuild[$weight] = $route;
        }
        //sort based on key value to order our routes
        ksort($toBuild);
        return $toBuild;
    }
}
