<?php

use apexl\Io\includes\Routes;
use apexl\Io\modules\menu\entities\menuLinkEntity;
use Phinx\Seed\AbstractSeed;

class MenuSeeder extends AbstractSeed
{
    /**
     * Run Method.
     *
     * Write your database seeder using this method.
     *
     * More information on writing seeders is available here:
     * https://book.cakephp.org/phinx/0/en/seeding.html
     */
    public function run(): void
    {
        $data = [
            [
                'name' => 'Main Menu',
                'module' => 'menu',
                'links' => [(new menuLinkEntity())->setData([
                    "title" => "Home",
                    "routeName" => 'home',
                    "href" => Routes::getRoutePattern('home'),
                    "icon" => "home",
                ])]
            ],
            [
                'name' => 'Account Menu',
                'module' => 'menu',
                'links' => [(new menuLinkEntity())->setData([
                    "title" => "Settings",
                    "routeName" => 'user.display.settings',
                    "href" => Routes::getRoutePattern('user.display.settings'),
                    "icon" => "cogs",
                    ]),
                    (new menuLinkEntity())->setData([
                        "title" => "Logout",
                        "routeName" => 'user.logout',
                        "href" => Routes::getRoutePattern('user.display.logout'),
                        "icon" => "sign-out",
                    ]),
                ],
            ],
        ];

        $this->table('menus')
            ->insert($data)
            ->saveData();
    }
}
