<?php

declare(strict_types=1);

namespace apexl\Io\modules\menu\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\includes\Module;
use apexl\Io\modules\menu\interfaces\registersMenuItems;
use apexl\Io\modules\menu\services\Menu;

final readonly class registerMenuItems extends AbstractHook
{

    public function __construct(private Menu $menu)
    {
    }

    static protected function hooks(): array
    {
        return ['initialiseModule'];
    }

    public function __invoke(Module $module): Module
    {
        if (method_exists($module, 'registerMenuItems')) {
            logger('error')->warning(
                sprintf(
                    'Deprecation - Module \'%s\' should register menu items by implementing %s\n',
                    $module->getName(),
                    registersMenuItems::class,
                ),
            );
            $module->registerMenuItems($this->menu);

            return $module;
        }

        if ($module instanceof registersMenuItems) {
            $module->menuItems($this->menu);
        }

        return $module;
    }
}
