<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreateMenusTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('menus')
            ->addColumn('name', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('module', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('permission', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
                'default' => 'AllowAll',
            ])
            ->addColumn('active', AdapterInterface::PHINX_TYPE_BOOLEAN, [
                'null' => false,
                'default' => true,
            ])
            ->addColumn('weight', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
                'default' => 0,
            ])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addColumn('created_by', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addColumn('modified', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addColumn('modified_by', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addIndex('name')
            ->addIndex('active')
            ->create();
    }
}
