<?php

namespace apexl\Io\modules\menu\entities;

use apexl\entityCore\enums\Casts;
use apexl\entityCore\traits\hasCasts;
use apexl\Io\includes\Entity;
use apexl\Io\modules\menu\entities\operators\menuLinksOperator;
use DateTimeImmutable;

/**
 * @property int $id
 * @property int $mid
 * @property string $routeName
 * @property string $href
 * @property string $permission
 * @property int $parentId
 * @property string $title
 * @property string $icon
 * @property bool $active
 * @property int $weight
 * @property DateTimeImmutable $created
 * @property DateTimeImmutable $modified
 *
 * @mixin menuLinksOperator
 */
class menuLinkEntity extends Entity
{
    use hasCasts;

    public function __construct()
    {
        parent::__construct('menu_links');
        $this->setOperator(new menuLinksOperator('menu_links'));
    }

    public function casts(): array
    {
        return [
            'id' => Casts::INT,
            'mid' => Casts::INT,
            'parentId' => Casts::INT,
            'active' => Casts::BOOL,
            'weight' => Casts::INT,
            'created' => Casts::DATETIME_STAMP,
            'modified' => Casts::DATETIME_STAMP,
        ];
    }
}
