<?php

namespace apexl\Io\modules\menu\services;

use apexl\Io\includes\HookManager;
use apexl\Io\modules\menu\entities\menuEntity;
use apexl\Io\modules\user\entities\userEntity;

/**
 * Class Menu
 * @package apexl\Io\modules\menu\services
 * //@todo this needs caching
 */
final class MenuManager
{
    final public const string HOOK__ADD_TO_MENU__ROUTE_NAME = 'menu.addToMenu.routeName';
    final public const string HOOK__ADD_TO_MENU__CONFIG = 'menu.addToMenu.config';

    protected array $menus;

    public function __construct(private HookManager $hookManager) {}

    /**
     * @param $routeName
     * @param array $config
     * @param string $menu
     */
    public function addToMenu($routeName, $config = [], $menu = 'navigation')
    {
        if (!isset($this->menus[$menu])) {
            $this->menus[$menu] = new menuEntity();
        }

        $routeName = $this->hookManager->processHook(self::HOOK__ADD_TO_MENU__ROUTE_NAME, $routeName, $menu, $config);
        $config = $this->hookManager->processHook(self::HOOK__ADD_TO_MENU__CONFIG, $config, $menu, $routeName);

        $this->menus[$menu]->addToMenu(
            $routeName,
            $config['title'] ?? '',
            $config['icon'] ?? '',
            $config['weight'] ?? 0,
            $config['parent'] ?? false,
            $config['replacements'] ?? []
        );
    }

    /**
     * @param $routeName
     * @param string $menu
     * @return mixed
     */
    public function getMenuItem($routeName, $menu = 'navigation')
    {
        if (isset($this->menus[$menu])) {
            return $this->menus[$menu]->getMenuItem($routeName);
        }

        return null;
    }

    /**
     * @param $route
     * @param string $menu
     */
    public function generateBreadcrumbs($route, $menu = 'navigation'): array
    {
        return $this->menus[$menu]->generateBreadcrumbs($route);
    }

    /**
     * This method allows us to take all registered routes and build a menu with them. We register routes as their own dynamic entity
     * @param bool $filterByPermission
     * @param string $menu
     */
    public function getAllItemsAsMenu(userEntity $user, $menu = 'navigation', $filterByPermission = true): array
    {
        //We cache generated menu items so that the order can be controlled by admin users.
        return isset($this->menus[$menu]) ? $this->menus[$menu]->getAllItemsAsMenu($user, $filterByPermission) : [];
    }

    /**
     * @param string $name
     * @return object
     */
    public function getMenu($name = 'navigation')
    {
        return isset($this->menus[$name]) ? $this->menus[$name] : new menuEntity();
    }

    /**
     * Get the name of the Menu containing the current route.
     * Return first menu if no match found
     * @return $menu (object)
     */
    public function getActiveMenu()
    {
        if (isset($this->menus) && is_array($this->menus)) {
            foreach ($this->menus as $name => $menu) {
                $firstMenu = $menu;
                if ($menu->isCurrentMenu()) {
                    return $menu;
                }
            }
        }

        return $firstMenu ?? null;
    }
}
