<?php

declare(strict_types=1);

namespace apexl\Io\modules\menu\hooks;

use apexl\Io\includes\Module;
use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\menu\interfaces\ProvidesMenuItemsInterface;
use apexl\Io\modules\menu\services\MenuManager;

final readonly class registerMenuItems implements AbstractHook
{
    public function hooks(): array
    {
        return ['initialiseModule'];
    }

    public function __invoke(Module $module, MenuManager $menu): Module
    {
        if (method_exists($module, 'registerMenuItems')) {
            logger('error')->warning(
                sprintf(
                    'Deprecation - Module \'%s\' should register menu items by implementing %s\n',
                    $module->getName(),
                    ProvidesMenuItemsInterface::class,
                ),
            );
            $module->registerMenuItems($menu);

            return $module;
        }

        if ($module instanceof ProvidesMenuItemsInterface) {
            $module->menuItems($menu);
        }

        return $module;
    }
}
