<?php

declare(strict_types=1);

namespace apexl\Io\modules\menu\Factories;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\menu\includes\menuItem;
use DI\Container;

final readonly class MenuItemFactory
{
    public function __construct(private Container $container, private RouteManager $routeManager) {}

    public function make(array $item): MenuItem
    {
        $route = $this->routeManager->getRoute($item['routeName']);
        $path = $route ? $this->routeManager->getRoutePattern($route->getName(), $item['replacements'] ?? []) : '';

        return $this->container->make(MenuItem::class, ['item' => $item, 'route' => $route, 'path' => $path]);
    }
}
