<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirrorS3\Dto;

class S3ConfigDto
{
    public function __construct(
        public string $bucket,
        public string $version,
        public string $endpoint,
        public bool $use_path_style_endpoint,
        public string $key,
        public string $secret,
        public string $remote_download__frontend,
        public string $remote_download__backend,
    ) {
    }

    public static function fromConfig(object $config): S3ConfigDto
    {
        return new S3ConfigDto(
            bucket: $config->bucket,
            version: $config->version,
            endpoint: $config->endpoint,
            use_path_style_endpoint: $config->use_path_style_endpoint,
            key: $config->credentials->key,
            secret: $config->credentials->secret,
            remote_download__frontend: $config->remote_download->frontend,
            remote_download__backend: $config->remote_download->backend,
        );
    }
}
