<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirrorS3;

use apexl\Config\Singleton as Config;
use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\mirrorS3\Dto\S3ConfigDto;
use Aws\S3\S3Client;

class mirrorS3Module extends Module implements HasServicesInterface
{
    public function addServices(): array
    {
        $config = Config::getInstance();

        return [
            S3ConfigDto::class => fn() => S3ConfigDto::fromConfig($config->mirror->s3),
            S3Client::class => function () use ($config) {
                $s3Config = System::getRegisteredService(S3ConfigDto::class);

                return new S3Client([
                    'version' => $s3Config->version,
                    'region' => 'us-east-1', #Leave this, regardless of actual region; this is a Digital Ocean quirk(tm)
                    'endpoint' => $s3Config->endpoint,
                    'use_path_style_endpoint' => $s3Config->use_path_style_endpoint,
                    'credentials' => [
                        'key' => $s3Config->key,
                        'secret' => $s3Config->secret,
                    ],
                ]);
            },

        ];
    }


}
