<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirror\Exception;

use Exception;
use Throwable;

class UploaderException extends Exception
{
    private ?string $clientErrorCode;
    private ?string $clientErrorMessage;

    public function __construct(
        string $clientErrorCode = null,
        ?string $clientErrorMessage = null,
        $message = '',
        $code = 0,
        Throwable $previous = null
    ) {
        parent::__construct($message, $code, $previous);
        $this->clientErrorCode = $clientErrorCode;
        $this->clientErrorMessage = $clientErrorMessage;
    }

    public function getClientErrorCode(): ?string
    {
        return $this->clientErrorCode;
    }

    public function getClientErrorMessage(): ?string
    {
        return $this->clientErrorMessage;
    }
}
