<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirror\Service\Hook;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\mirror\Interface\UploaderServiceInterface;
use app\module\apollo\Helper\UploadableFileEntity;

final readonly class MirrorFileEntityToCloud extends AbstractHook
{
    public function __construct(private UploaderServiceInterface $uploader)
    {
    }

    static protected function hooks(): array
    {
        return [
            'postEntityInsert',
        ];
    }

    public function __invoke(array $data, string $table, string $id): array
    {
        if ($table === 'files') {
            $uploadable = UploadableFileEntity::fromId((int) $id);
            $this->uploader->upload($uploadable);

            /** @TODO remove original file */
        }

        return $data;
    }
}
