<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirror\Interface;

use apexl\Io\modules\mirror\Dto\UploadedObjectDto;
use apexl\Io\modules\mirror\Exception\UploaderException;

interface UploaderServiceInterface
{
    /**
     * @param  Uploadable[]  $toUpload
     */
    public function uploadAll(array $toUpload): void;

    public function upload(Uploadable $uploadable): void;

    public function isUploaded(string $key): bool;

    /**
     * @throws  UploaderException
     */
    public function getUploaded(string $key): UploadedObjectDto;
}
