<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirror\Hook;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\mirror\Helper\UploadableFileEntity;
use apexl\Io\modules\mirror\Interface\UploaderServiceInterface;

final readonly class MirrorFileEntityToCloud extends AbstractHook
{
    public function __construct(private UploaderServiceInterface $uploader)
    {
    }

    static protected function hooks(): array
    {
        return [
            'postEntityInsert:files',
        ];
    }

    public function __invoke(array $data, int $id): array
    {
        $uploadable = UploadableFileEntity::fromId($id);
        $this->uploader->upload($uploadable);

        /** @TODO remove original file */

        return $data;
    }
}
