<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirror\Helper;

use apexl\Io\modules\file\entities\fileEntity;
use DI\Container;

final readonly class UploadableFileEntityFactory
{
    public function __construct(private Container $container) {}

    public function fromId(int $id): UploadableFileEntity
    {
        $fileEntity = new fileEntity();
        $fileEntity->load($id);

        return $this->make($fileEntity);
    }

    public function make(fileEntity $fileEntity): UploadableFileEntity
    {
        return $this->container->make(UploadableFileEntity::class, [
            'fileEntity' => $fileEntity,
        ]);
    }
}