<?php

declare(strict_types=1);

namespace apexl\Io\modules\mirror\Hook;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\mirror\Helper\UploadableFileEntityFactory;
use apexl\Io\modules\mirror\Interface\UploaderServiceInterface;

final readonly class MirrorFileEntityToCloud implements AbstractHook
{
    public function __construct(private UploaderServiceInterface $uploader, private UploadableFileEntityFactory $uploadableFileEntityFactory) {}

    public function hooks(): array
    {
        return [
            'postEntityInsert:files',
        ];
    }

    public function __invoke(array $data, int $id): array
    {
        $uploadable = $this->uploadableFileEntityFactory->fromId($id);
        $this->uploader->upload($uploadable);

        /** @TODO remove original file */

        return $data;
    }
}
