<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreateFileLocks extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('file_locks')
            ->addColumn('file', AdapterInterface::PHINX_TYPE_INTEGER, [
                'null' => false,
                'signed' => false,
            ])
            ->addColumn('type', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('datetime', AdapterInterface::PHINX_TYPE_DATETIME, [
                'null' => false,
            ])
            ->addIndex(['file', 'type'], [Index::UNIQUE => true])
            ->create();
    }
}
