<?php declare(strict_types=1);

namespace apexl\Io\modules\notifierTwilio\dto;

use apexl\Config\Singleton as Config;
use Exception;
use Spatie\DataTransferObject\FlexibleDataTransferObject;

class TwilioConfigDto extends FlexibleDataTransferObject
{
    public string $sid;
    public string $token;
    public string $from;

    /**
     * @throws Exception
     */
    public static function fromConfig(): TwilioConfigDto
    {
        $config = Config::getInstance()->notifier->drivers->sms->twilio;

        return new TwilioConfigDto((array) $config);
    }
}
