<?php declare(strict_types=1);

namespace apexl\Io\modules\notifierTwilio\dto;

final readonly class TwilioConfigDto
{
    public function __construct(
        public string $sid,
        public string $token,
        public string $from,
    ) {}

    public static function fromConfig(): TwilioConfigDto
    {

        return new TwilioConfigDto(
            config('notifier.drivers.sms.twilio.sid'),
            config('notifier.drivers.sms.twilio.token'),
            config('notifier.drivers.sms.twilio.from'),
        );
    }
}
