<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\drivers;

use apexl\Io\modules\notifier\interfaces\emailNotifierDriverInterface;
use apexl\Io\services\Mailer;
use PHPMailer\PHPMailer\Exception;

class smtpEmailNotifierDriver implements emailNotifierDriverInterface
{
    private bool $isHtml = true;

    /**
     * @throws Exception
     */
    public function send(string $to, string $subject, string $body): void
    {
        $client = new Mailer();
        $client->addAddress($to);
        $client->Subject = $subject;
        $client->Body = $body;
        $client->SMTPSecure = '';
        $client->isHTML($this->isHtml);

        $client->send();
    }

    public function isHtml(bool $isHtml = true): void
    {
        $this->isHtml = $isHtml;
    }
}
