<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\notifiers;

use apexl\Io\modules\notifier\interfaces\emailNotifierDriverInterface;
use apexl\Io\modules\notifier\interfaces\notifierInterface;

abstract class emailNotifier extends notifier implements notifierInterface
{
    protected emailNotifierDriverInterface $driver;

    abstract protected function to(): string;
    abstract protected function subject(): string;
    abstract protected function body(): string;

    public function __construct(emailNotifierDriverInterface $driver)
    {
        parent::__construct();

        $this->driver = $driver;
    }

    public function send(): void
    {
        if ($this->shouldSend()) {
            $this->driver->send(
                $this->to(),
                $this->subject(),
                $this->body(),
            );

            $this->logger->debug(sprintf('Sent email notification to %s', $this->to()));
        }
    }

    protected function shouldSend(): bool
    {
        return true;
    }
}
