<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\notifiers;

use apexl\Io\modules\notifier\exceptions\notifierException;
use apexl\Io\modules\notifier\interfaces\notifierInterface;

class multipleNotifier extends notifier implements notifierInterface
{
    /** @var notifierInterface[]  */
    private array $notifiers;

    public function __construct(array $notifiers)
    {
        parent::__construct();

        $this->notifiers = $notifiers;
    }

    /**
     * @throws notifierException
     */
    public function send(): void
    {
        foreach ($this->notifiers as $notifier) {
            $notifier->send();
        }
    }
}
