<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\notifiers;

use apexl\Io\modules\notifier\exceptions\notifierException;
use apexl\Io\modules\notifier\interfaces\notifierInterface;
use Exception;

class multipleNotifier extends notifier implements notifierInterface
{
    /**
     * @param  notifierInterface[]  $notifiers
     * @throws Exception
     */
    public function __construct(private readonly array $notifiers)
    {
        parent::__construct();
    }

    /**
     * @throws notifierException
     */
    public function send(): void
    {
        foreach ($this->notifiers as $notifier) {
            $notifier->send();
        }
    }
}
