<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\drivers;

use apexl\Io\factories\MailerFactory;
use apexl\Io\modules\notifier\interfaces\emailNotifierDriverInterface;
use PHPMailer\PHPMailer\Exception;

class smtpEmailNotifierDriver implements emailNotifierDriverInterface
{
    private bool $isHtml = true;

    public function __construct(private MailerFactory $mailerFactory) {}

    /**
     * @throws Exception
     */
    public function send(string $to, string $subject, string $body): void
    {
        $client = $this->mailerFactory->make();

        $client->addAddress($to);
        $client->Subject = $subject;
        $client->Body = $body;
        $client->SMTPSecure = '';
        $client->isHTML($this->isHtml);

        $client->send();
    }

    public function isHtml(bool $isHtml = true): void
    {
        $this->isHtml = $isHtml;
    }
}
