<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\factories;

use apexl\Io\modules\notifier\interfaces\notifierInterface;
use DI\Container;
use function apexl\Io\assertInstanceOf;

class NotifierFactory
{
    public function __construct(private Container $container) {}

    /**
     * @param class-string<notifierInterface> $notifier
     */
    public function make(string $notifier, array $params = []): notifierInterface
    {
        assertInstanceOf($notifier, notifierInterface::class);

        return $this->container->make($notifier, $params);
    }
}
