<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\notifiers;

use apexl\Config\Singleton as Config;
use apexl\Io\modules\logger\interfaces\loggerInterface;
use apexl\Io\modules\logger\services\loggerStore;
use apexl\Io\modules\notifier\interfaces\notifierInterface;
use apexl\Io\modules\notifier\logger\dummyLogger;
use Exception;
use function apexl\Io\config;

abstract class notifier implements notifierInterface
{
    protected loggerInterface $logger;

    /**
     * @throws Exception
     */
    public function __construct()
    {
        $stream = config('notifier.logStream', loggerStore::DEFAULT__LOGGER_STREAM);

        $this->logger = class_exists('apexl\Io\modules\logger\loggerModule') ?
            logger($stream) : new dummyLogger();
    }
}
