<?php

declare(strict_types=1);

namespace apexl\Io\modules\notifier\notifiers;

use apexl\Io\modules\notifier\exceptions\notifierException;
use apexl\Io\modules\notifier\interfaces\notifierInterface;
use apexl\Io\modules\notifier\interfaces\smsNotifierDriverInterface;

abstract class smsNotifier extends notifier implements notifierInterface
{
    private smsNotifierDriverInterface $driver;

    abstract protected function to(): string;
    abstract protected function body(): string;

    public function __construct(smsNotifierDriverInterface $driver)
    {
        parent::__construct();

        $this->driver = $driver;
    }

    /**
     * @throws notifierException
     */
    public function send(): void
    {
        if ($this->shouldSend()) {
            $this->driver->send($this->to(), $this->body());
            $this->logger->debug(sprintf('Sent SMS notification to %s', $this->to()));
        }
    }

    protected function shouldSend(): bool
    {
        return true;
    }
}
