<?php

namespace apexl\Io\modules\page\services;

use apexl\ClassEngine\EngineSingleton;
use apexl\Config\Singleton;
use apexl\Io\modules\component\entities\componentEntity;

abstract class Page extends EngineSingleton{
    protected $metadata;
    protected $config;
    protected $components = [];

    protected function __construct()
    {
        $this->metadata = (object)[];
        $this->config = Singleton::getInstance();
    }

    public function setMetaTitle($title){
        $this->metadata->title = $title;
        return $this;
    }

    public function setMetaDescription($desc){
        $this->metadata->description = $desc;
        return $this;
    }

    public function setMetadata($metaKey, $metaValue){
        $this->metadata->$metaKey = $metaValue;
        return $this;
    }

    public function addComponent(componentEntity $component){
        $this->components[] = $component;
        return $this;
    }

    /**
     * Get the top level component by name.
     * @TODO change how components are registered maybe?
     * @param $name
     * @return componentEntity|bool
     */
    public function getComponent($name){
        $noComponents = count($this->components);
        for($i=0;$i<$noComponents;++$i){
            if($this->components[$i]->name == $name){
                return $this->components[$i];
            }
        }
        return FALSE;
    }

    /**
     * Allow top level components to be replaced
     * @param $name
     * @param componentEntity $component
     * @return bool
     */
    public function replaceComponent($name, componentEntity $component){
        $noComponents = count($this->components);
        $replaced = FALSE;
        for($i=0;$i<$noComponents;++$i){
            if($this->components[$i]->name == $name){
                $this->components[$i] = $component;
                $replaced = TRUE;
            }
        }
        return $replaced;
    }

    public function getPage(){
        $data = [];
        $data['metadata'] = $this->metadata;
        foreach($this->components as $component){
            //we need to decode the cast components as they will be json encoded.
            //We do this to ensure we have all nested data.
            $data['components'][] = json_decode((string) $component);
        }
        return $data;
    }

    public function __toString()
    {
        return json_encode($this->getPage());
    }
}