<?php

namespace apexl\Io\modules\page\services;

use apexl\ClassEngine\EngineSingleton;

/**
 * Class Render
 * Provides a global render store for pages.
 * Allows various projects to manipulate the default display output of modules
 * @package apexl\Io\modules\page\services
 */
class Render extends EngineSingleton {
    protected static $pages = [];
    protected static $activePage = "default";

    protected function __construct()
    {
        parent::__construct();
    }

    public static function setActive($activePage){
        self::$activePage = $activePage;
    }

    public static function registerDefault(Page $page){
        self::$pages["default"] = $page;
    }

    public static function registerPage($name, Page $page){
        self::$pages[$name] = $page;
    }

    public static function getPage($name){
        return self::$pages[$name] ?? FALSE;
    }

    public static function build(){
        return isset(self::$pages[self::$activePage]) ? self::$pages[self::$activePage]->getPage() : [];
    }
}