<?php
namespace apexl\Io\modules\paymentDisplay\components;

use apexl\Config\Singleton;
use apexl\encryption\Encrypt;
use apexl\Io\includes\Routes;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\BasicTable;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\SimpleButton;
use apexl\Io\modules\display\components\TableButton;
use apexl\Io\modules\invoice\services\invoiceService;
use apexl\Io\modules\payment\entities\paymentTokenEntity;
use apexl\Io\modules\payment\entities\userCreditEntity;
use apexl\Io\modules\payment\providers\stripeProvider;
use apexl\Io\modules\payment\services\paymentService;
use apexl\Io\modules\user\services\currentUser;
use apexl\Vault\Vault;

class viewTiles {

    public static function latestPayments()
    {
        $components = [];

    }

    public static function paymentCards()
    {
        $components = [];
        $config = Singleton::getInstance();
        $currentuser = currentUser::getCurrentUser();
        $stripe = new stripeProvider();
        $paymentToken = new paymentTokenEntity();
        $encrypt = new Encrypt();
        $tokens = $paymentToken->getByUser($currentuser->id);
        $paymentService = new paymentService();
        $invoiceService = new invoiceService();

        $data = [];
        foreach ($tokens as $token) {
            if ($token->setup_complete == 1 && $token->deleted == 0) {

                $paymentMethodRefDecrypted = $encrypt->decrypt($token->payment_method_ref, $token->payment_method_ref_iv, $config->app->encryption->key);
                if ($paymentMethod = $stripe->getPaymentMethod($paymentMethodRefDecrypted)) {
                    $data['rows'][] = [
                        'id' => $token->id,
                        'type' => $paymentMethod->card->brand,
                        'name' => $token->ref,
                        'description' => ucfirst($paymentMethod->card->funding) . ' card ending in **** '.$paymentMethod->card->last4 . '<br>expires: '.$paymentMethod->card->exp_month.'/'.$paymentMethod->card->exp_year,
                        'default' => $token->default_token ? '<strong>default</strong>' : '',
                    ];
                }
            }
        }

        $title = new ContentTitle();
        $title->addTitle('Payment Cards');
        if ($invoiceService->getTotalCredit($currentuser->id) > 0) {
        $title->addContent("Available credit: <strong>£{$invoiceService->getTotalCredit($currentuser->id)}</strong>");
        }


        $table = (new BasicTable($data))
            ->addComponent((new TableButton())
                ->addRoute(Routes::getRoutePattern('paymentTokenEntity.display.put', [], FALSE))
                ->addText("edit")
            )->addComponent((new TableButton())
                ->addRoute(Routes::getRoutePattern('paymentTokenEntity.display.delete', [], FALSE))
                ->addText("delete")
            );

        $button = new BasicLink();
        $button->addRoute($paymentService->getCardSetupLink($currentuser));
        $button->addText('Add New Card');
        $button->addClass('add-new-card-button btn btn-primary text-center');

        return genericComponents::dashboardBlockWrapper([$title, $table, $button])->addClass('col-4 col-lg-4 col-xl-4');
    }

}